﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="Pectra.Forms.FrontEnd.Host.Web.v2.Default" %>


<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Proyectos de Aplicaciones</title>
    <script src="../Includes/Bootstrap/js/jquery-3.2.1.min.js"></script>

    <!--Bootstrap-->
    <link type="text/css" href="../Includes/Bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link type="text/css" href="../Includes/Site.css" rel="stylesheet" />
    <script type="text/javascript" src="../Includes/Bootstrap/js/bootstrap.min.js"></script>

    <!--DataTables-->
    <link type="text/css" href="~/Includes/DataTables/css/dataTables.bootstrap.min.css" rel="stylesheet" />
    <link type="text/css" href="~/Includes/DataTables/css/responsive.bootstrap.min.css" rel="stylesheet" />
    <link type="text/css" href="~/Includes/DataTables/css/select.bootstrap.min.css" rel="stylesheet" />
    <script type="text/javascript" src="../Includes/Scripts/DataTables/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/responsive.bootstrap.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.select.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.lang.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.buttons.min.js"></script>

    <!--Alert-->
    <link type="text/css" rel="stylesheet" href="Css/alert.css" />
    <script type="text/javascript" src="Scripts/alert.js"></script>
    <script type="text/javascript" src="Scripts/ee.min.js"></script>

    <!--Moment-->
    <script type="text/javascript" src="../Includes/Scripts/moment-with-locales.min.js"></script>

    <!--Bootbox-->
    <script type="text/javascript" src="../Includes/Bootstrap/js/bootbox.js"></script>

    <link type="text/css" rel="stylesheet" href="../Includes/Bootstrap/css/font-awesome.min.css"/>

    <link type="text/css" rel="stylesheet" href="Css/default.css?a"/>
    <script>

        
        var $txtUsId;
        var $txtProyectoId;
        var $txtProcesoId;
        var $txtTrxId;
        var $msgProcessing;
        var _tableProyectos;
        var _tableVersiones;
        var $mdlVersiones;

        function obtenerProyectos() {
            var param = {};
            $.ajax({
                type: "POST",
                url: "Default.aspx/GetProyectos",
                data: JSON.stringify(param),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showMessage(2, "Se produjo un error. Intente nuevamente.");
                    $msgProcessing.hide();

                },
                success: function (result) {
                    llenarTablaProyectos(result.d);
                }
            });
        }

        function llenarTablaProyectos(data) {

            var oProyectos = JSON.parse(data);

            $('#tableProyectos').DataTable().clear();
            $('#tableProyectos').DataTable().destroy();

            try {


                _tableProyectos = $("#tableProyectos").DataTable({
                    data: oProyectos,
                    "order": [[0, "desc"]],
                    "columnDefs": [
                        { width: '15%', targets: 0, className: 'cellC' },
                        { width: '40%', targets: 1 },
                        {
                            width: '15%',
                            targets: [2],
                            render: function (data) {
                                var sDate = '-';
                                if (moment(data).isValid()) {
                                    sDate = moment(data).format("L") + ' ' + moment(data).format("HH:mm:ss");
                                }
                                return sDate;
                            }
                        },
                        { width: '20%', targets: 3, className: 'cellC' },
                        { width: '5%', targets: 4, className: 'cellC' },
                        { width: '5%', targets: 5, className: 'cellCNoPaddingLeft' }
                         <%if (EsAdministrador) { %> 
                             , { width: '5%', targets: 6, className: 'cellCNoPaddingLeft' }
                        <% } %>
                    ],
                    "columns": [
                        { name: 'IdProyecto', "data": 'IdProyecto', title: "Número" },
                        { name: 'Nombre', "data": 'Nombre', title: "Nombre" },
                        { name: 'FechaInicio', "data": 'FechaInicio', title: "Fecha de Inicio", sortable: false, searchable: false },
                        { name: 'Responsable', "data": 'Responsable', title: "Responsable", sortable: false, searchable: false },

                        {
                            name: 'Edition', "data": null, title: "Editar", sortable: false, searchable: false,
                            render: function (data, type, row) {
                                if (type === 'display') {
                                    return '<a class="btn btn-primary" href="" aria-label="Editar" onclick="EditarActividad(' + row.IdProyecto + ');return false">' +
                                            '<i class="fa fa-edit" aria-hidden="true"></i></a>'
                                }
                                return data;
                            }
                        },
                        {
                            name: 'Historial', "data": null, title: "Versión", sortable: false, searchable: false,
                            render: function (data, type, row) {
                                if (type === 'display') {
                                    return '<a class="btn btn-info" href="" aria-label="Ver historial de versiones" onclick="VerHistorial(' + row.IdProyecto + ');return false">' +
                                           '<i class="fa fa-clock-o" aria-hidden="true"></i></a>'
                                }
                                return data;
                            }
                        }
                        <%if (EsAdministrador) { %> ,{
                            name: 'Delete', "data": null, title: "Borrar", sortable: false, searchable: false,
                            render: function (data, type, row) {
                                if (type === 'display') {

                                    return '<a class="btn btn-danger" href="" aria-label="Eliminar Proyecto" onclick="ConfirmaEliminarProyecto(' + row.IdProyecto + ', \'' + row.Nombre + '\');return false">' +
                                        //'<i class="fa fa-database"></i>
                                        '<i class="fa fa-trash" aria-hidden="true"></i></a>'
                                }
                                return data;
                            }
                        }
                       <% } %>
                    ]
                });
                } catch (e) {

            }
            $msgProcessing.hide();
        }



            function obtenerVersiones(PrjId) {
                var param = {};
                param.sidproyecto = PrjId;

            $.ajax({
                    type: "POST",
                url: "Default.aspx/GetVersiones",
                data: JSON.stringify(param),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                        alert("Request: " + XMLHttpRequest.toString() + "\n\nStatus: " + textStatus + "\n\nError: " + errorThrown);
                    },
                success: function (result) {
                        llenarTablaVersiones(result.d, PrjId);
                    }
                });
            }

            function RestaurarVersion(H_PrjId, PrjId) {
                var param = {};
                param.sh_idproject = H_PrjId;
                param.sidproyecto = PrjId;
            $msgProcessing.show();
            $.ajax({
                    type: "POST",
                url: "Default.aspx/RestaurarVersion",
                data: JSON.stringify(param),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                        alert("Request: " + XMLHttpRequest.toString() + "\n\nStatus: " + textStatus + "\n\nError: " + errorThrown);
                    $msgProcessing.hide();
                    },
                success: function (result) {
                    $mdlVersiones.modal('hide');
                        obtenerProyectos();
                    }
                });
            }

            function CrearVersion(H_PrjId) {
                var param = {};
                param.sh_idproject = H_PrjId;
                param.usrid = $txtUsId.val();
            $msgProcessing.show();
            $.ajax({
                    type: "POST",
                url: "Default.aspx/CrearNuevaVersion",
                data: JSON.stringify(param),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                        alert("Request: " + XMLHttpRequest.toString() + "\n\nStatus: " + textStatus + "\n\nError: " + errorThrown);
                        $msgProcessing.hide();
                    },
                success: function (result) {
                        $mdlVersiones.modal('hide');
                        obtenerProyectos();
                    }
                });
            }
          <%if (EsAdministrador)
        { %> 
            function ConfirmaEliminarProyecto(PrjId, PrjName) {
                bootbox.dialog({
                    title: "Eliminación de Proyecto",
                message: "¿Está seguro que desea eliminar el proyecto </br> <b>" + PrjId + " - " + PrjName + "<b> ?",
                backdrop: true,
                buttons: {
                        si: {

                            label: '<i class="fa fa-check"></i> Si',
                        className: 'btn-success',
                        callback: function () {
                                EliminarProyecto(PrjId);
                            }
                        },
                    no: {
                            label: '<i class="fa fa-times"></i> No',
                        className: 'btn-danger'
                        /* ,callback: function () {
                             //alert('no');
                         }
                         */
                    }
                    }

                });
                return;
            }
            function EliminarProyecto(PrjId) {
                var param = {};
                param.sidproject = PrjId;
                param.strxid = $txtTrxId.val();

            $msgProcessing.show();
            $.ajax({
                    type: "POST",
                url: "Default.aspx/EliminarProyecto",
                data: JSON.stringify(param),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                        alert("Request: " + XMLHttpRequest.toString() + "\n\nStatus: " + textStatus + "\n\nError: " + errorThrown);
                    $msgProcessing.hide();
                    },
                success: function (result) {
                        obtenerProyectos();
                    }
                });
            }
          <% } %> 
            function llenarTablaVersiones(data, PrjId) {

                var oProyectos = JSON.parse(data);

            $('#tableVersiones').DataTable().clear();
            $('#tableVersiones').DataTable().destroy();

                try {
                    _tableVersiones = $("#tableVersiones").DataTable({
                        data: oProyectos,
                    "order": [[1, "desc"]],
                    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
                    "paging": false,//Dont want paging                
                    "bPaginate": false,//Dont want paging   
                    "columnDefs": [
                        { targets: 0 },
                        { targets: 1, className: 'cellC' },
                        {
                          targets: 2,
                            render: function (data) {
                                var sDate = '-';
                                if (moment(data).isValid()) {
                                    sDate = moment(data).format("L") + ' ' + moment(data).format("HH:mm:ss");
                                }
                                return sDate;
                            }
                        },
                        { targets: 3, className: 'cellC' },
                        { targets: 4, className: 'cellC' }
                    ],
                    "columns": [
                        { name: 'H_IdProyecto', width: '0px', "data": 'H_IdProyecto', sortable: false, searchable: false, visible: false },
                        { name: 'Version', width: '15%',  "data": 'Version', title: "Versión", sortable: false, searchable: false },
                        { name: 'FechaBack', "data": 'FechaBack', title: "Fecha de Backup", sortable: false, searchable: false },
                        {
                            name: 'Copy', width: '15%', "data": null, title: "Copiar", sortable: false, searchable: false,
                            render: function (data, type, row) {
                            if (type === 'display') {
                                return '<a class="btn btn-primary" href="" aria-label="Crear versión" onclick="CrearVersion(' + row.H_IdProyecto + ');return false">' +
                                      '<i class="fa fa-files-o" aria-hidden="true"></i></a>'
                                                }
                            return data;
                        }
                        },
                        {
                            name: 'Restore', width: '15%', "data": null, title: "Restaurar", sortable: false, searchable: false,
                            render: function (data, type, row) {
                            if (type === 'display') {
                                return '<a class="btn btn-primary" href="" aria-label="Restaurar versión" onclick="RestaurarVersion(' + row.H_IdProyecto + ', ' + PrjId + ');return false">' +
                                    '<i class="fa fa-level-down" aria-hidden="true"></i></a>'
                                                }
                            return data;
                        }
                        }
                    ]
                });

            } catch (e) {

            }
            $msgProcessing.hide();
        }


        function EditarActividad(PrjId) {
            var url = "EditProject.aspx?TrxId=" + $txtTrxId.val() + "&PrjId=" + PrjId;
            window.location = url;
        }

        function VerHistorial(PrjId) {
            $msgProcessing.show();
            $("#mdlVersiones").modal();
            obtenerVersiones(PrjId);

        }
        function nuevoProyecto() {
            var url = "EditProject.aspx?TrxId=" + $txtTrxId.val() + "&PrjId=0";
            window.location = url;
        }


        function HandlePopupResult(result) {
            //    if (result == "OK")
            //     obtenerActividades();
        }



        $(document).ready(function () {


            moment.locale('<%=System.Threading.Thread.CurrentThread.CurrentCulture.Name%>');

            $txtUsId = $("#txtUsId");
            $txtProyectoId = $("#txtProyectoId");
            $txtProcesoId = $("#txtProcesoId");
            $txtTrxId = $("#txtTrxId");
            $msgProcessing = $("#msgProcessing");
            $mdlVersiones = $("#mdlVersiones");
            obtenerProyectos();

        });



    </script>
</head>


<body>
    <form id="form1" runat="server">


        <!-- Progreso -->
        <div class="modal fade in" id="msgProcessing" style="display: block; background-color: rgba(0, 0, 0, 0.3)">
            <div class="modal-dialog" style="margin-top: 239px;">
                <div class="modal-content rounded" style="background-color: white; -webkit-box-shadow: none; -moz-box-shadow: none; -o-box-shadow: none; border: none; text-align: center;" id="modal-content">

                    <div class="modal-body" style="text-align: center; display: inline-block; border: 0px;" id="modal-body">
                        <span style="font-size: 40px; vertical-align: middle;" class='fa fa-gear fa-spin' id="iProcessing"></span>
                        <span style="font-size: 20px; vertical-align: middle; margin-left: 10px" id="lblProcesandoSolicitud">Cargando....</span>
                    </div>
                    <div class="modal-body" style="text-align: center; display: none; border: 0px;">
                        <span>El proceso puede durar varios minutos</span>
                    </div>

                </div>
            </div>
        </div>

        <!-- modal Historial de Versiones -->
        <div class="modal fade" id="mdlVersiones" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" aria-hidden="true" onclick="$('#mdlVersiones').modal('hide');">&times;</button>
                        <h4 class="modal-title" id="mdlLabelTitulo">Historial de Versiones</h4>
                    </div>
                    <div class="modal-body">
                        <div>

                            <div class="form-group ">

                                <!-- grilla de Historial -->
                                <div class="row" style="margin-bottom: 8px">
                                    <div class="col-sm-12" data-group-key="aVersiones">
                                        <div class="panel panel-default" id="pnlVersiones" style="margin: 10px;">
                                            <div class="panel-heading" style="display: none"></div>
                                            <div class="panel-body">
                                                <div class="row">
                                                    <table id="tableVersiones" class="table table-hover dt-responsive" style="width:100%;" cellspacing="0" >
                                                        <thead>
                                                            <tr>
                                                                <th></th>
                                                                <th></th>
                                                                <th></th>
                                                                <th></th>
                                                                <th></th>
                                                            </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                                <div class="row" style="text-align: right; padding-right: 20px; padding-bottom: 5px;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" onclick="$('#mdlVersiones').modal('hide');">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="navbar navbar-default navbar-fixed-top topnav" role="navigation">
            <div class="container topnav">
                <div class="navbar-header">
                    <div class="img-responsive img-nav-header">
                        <div style="float: left">
                            <img src="../Images/App.gif" />
                        </div>
                        <div style="float: left; vertical-align: middle;">
                            <label class="label-title">Pectra Forms</label>
                        </div>
                    </div>
                </div>
            </div>
        </nav>


        <!-- Pantalla Principal -->
        <div class="mainContent">

             <div class="container bootstrap snippet" style="max-width: 500px; right: 10px; float: right; position: fixed;">
                <div class="alert alert-success alert-white rounded" id="alertContainer" style="display: none; z-index: 999999;">
                    <button type="button" aria-hidden="true" class="close" onclick="$('#alertContainer').hide();">×</button>
                    <div class="icon">
                        <i class="fa fa-check" id="alertI"></i>
                    </div>
                    <div id="alertText"></div>

                </div>
            </div>

            <div class="container">

                <div style="display: none">
                    <input type="text" id="txtTrxId" runat="server" />
                    <input type="text" id="txtUsId" runat="server" />
                    <input type="text" id="txtProyectoId" runat="server" />
                    <input type="text" id="txtProcesoId" runat="server" />
                </div>

                <!--Proyectos-->
                <div class="panel panel-blue panel-custom">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a style="cursor: pointer" data-toggle="collapse" data-target="#section3">Proyectos de Aplicaciones
                            </a>
                        </h3>
                    </div>
                    <div id="section3" class="panel-body panel-collapse in">

                        <!-- grilla de Proyectos -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-12" data-group-key="aProyectos">
                                <div class="panel panel-default" id="pnlProyectos" style="margin: 10px;">
                                    <div class="panel-heading" style="display: none">Aplicaciones</div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <table id="tableProyectos" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <%if (EsAdministrador) { %> 
                                                        <th></th>
                                                        <% } %>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                        <div class="row" style="text-align: right; padding-right: 20px; padding-bottom: 5px;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="panel panel-custom">
                            <!-- botones -->
                            <div class="row" style="margin-top:-8px; margin-bottom: 8px">
                                <div class="col-sm-10" data-group-key="btns"></div>
                                <div class="col-sm-2" data-group-key="btns" style="text-align: right">
                                    <button type="button" class="btn btn-primary btn-block" id="Button2" runat="server" onclick="nuevoProyecto()">
                                        <i class="fa fa-plus-circle fa-1x" id="ibtns" style="float: left; margin-top: 2px;"></i>
                                        <span id="btns">Nuevo</span></button>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <footer style="margin-top: 20px;">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <p class="copyright text-muted small">Powered by Pectra Forms - Copyright &copy; <%= System.DateTime.Today.Year %></p>
                    </div>
                </div>
            </div>
        </footer>
    </form>
</body>
</html>
